package hu.afghangoat.events;

import com.hypixel.hytale.component.*;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.protocol.packets.interface_.Page;
import com.hypixel.hytale.server.core.asset.type.model.config.Model;
import com.hypixel.hytale.server.core.asset.type.model.config.ModelAsset;
import com.hypixel.hytale.server.core.entity.UUIDComponent;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.PageManager;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.modules.entity.component.*;
import com.hypixel.hytale.server.core.modules.entity.tracker.NetworkId;
import com.hypixel.hytale.server.core.modules.interaction.Interactions;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.npc.NPCPlugin;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.EntityEventSystem;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.server.core.event.events.ecs.BreakBlockEvent;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;

import java.util.Collection;
import java.util.List;
import java.util.Random;

//import hu.dragonyos.SelectionManager;

public class LuckyBreakEvent extends EntityEventSystem<EntityStore, BreakBlockEvent> {

    public LuckyBreakEvent() {
        super(BreakBlockEvent.class);

    }

    public static double distance(Vector3d a, Vector3d b) {
        double dx = a.x - b.x;
        double dy = a.y - b.y;
        double dz = a.z - b.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public void spawnEntity(String name, Vector3d position,Vector3f _rotation, World _world,Store<EntityStore> _store,int count){
        NPCPlugin npcP = NPCPlugin.get();

        int bearRole = npcP.getIndex(name);

        _world.execute(() -> {

            for(int i=0;i<count;i++){
                npcP.spawnEntity(
                        _store,
                        bearRole,
                        position,
                        _rotation, null, null
                );
            }

        });
    }

    public void addItem(Player player,String item_id, int count,Store<EntityStore> store){
        if(player != null){
            PageManager pageManager = player.getPageManager();
            //Store<EntityStore> store = player.getWorld().getEntityStore().getStore();
            pageManager.setPage(player.getReference(), store, Page.Inventory);

           // ItemStack item = new ItemStack("lucky_block");
            ItemStack item = new ItemStack(item_id, count);

            //inventory.removeItemStackFromSlot((short) 4);

            Inventory inventory = player.getInventory();
            inventory.getHotbar().addItemStack(item);
        }
    }

    @Override
    public void handle(int index,
                       @NonNullDecl ArchetypeChunk<EntityStore> archetypeChunk,
                       @NonNullDecl Store<EntityStore> store,
                       @NonNullDecl CommandBuffer<EntityStore> commandBuffer,
                       @NonNullDecl BreakBlockEvent breakBlockEvent) {



        String bid = breakBlockEvent.getBlockType().getId();
        if(!bid.equals("lucky_block")){
            return;
        }

        Vector3d blockPosition = breakBlockEvent.getTargetBlock().toVector3d();

        Vector3d destinate = blockPosition;
        destinate.y += 1.0;

        Vector3f rotation = new Vector3f(0, 0, 0); // rotation

        World world = store.getExternalData().getWorld();

        @SuppressWarnings("removal")
        List<Player> refs = world.getPlayers();

        Player nearest = null;
        double nearestDist = Double.MAX_VALUE;

        for (Player player : refs) {
            @SuppressWarnings("removal")
            double dist = distance(destinate, player.getPlayerRef().getTransform().getPosition());
            if (dist < nearestDist) {
                nearestDist = dist;
                nearest = player;
            }

        }
        Player player = nearest;





                    /*ModelAsset modelAsset = ModelAsset.getAssetMap().getAsset("Bear_Grizzly");
                    Model model = Model.createScaledModel(modelAsset, 1.0f);

                    //TransformComponent transform = store.getComponent(playerRef.getReference(), EntityModule.get().getTransformComponentType());


                    TransformComponent transform = new TransformComponent(destinate, vector3f);

                    holder.addComponent(TransformComponent.getComponentType(), new TransformComponent(destinate, vector3f));
                    holder.addComponent(PersistentModel.getComponentType(), new PersistentModel(model.toReference()));
                    holder.addComponent(ModelComponent.getComponentType(), new ModelComponent(model));
                    holder.addComponent(BoundingBox.getComponentType(), new BoundingBox(model.getBoundingBox()));
                    holder.addComponent(NetworkId.getComponentType(), new NetworkId(store.getExternalData().takeNextNetworkId()));
                    holder.addComponent(Interactions.getComponentType(), new Interactions()); // you need to add interactions here if you want your entity to be interactable
                    holder.ensureComponent(UUIDComponent.getComponentType());
                    holder.ensureComponent(Interactable.getComponentType()); // if you want your entity to be interactable

                    store.addEntity(holder, AddReason.SPAWN);*/

        Random rnd = new Random();
        switch (rnd.nextInt(44)){
            case 0:
                spawnEntity("Bear_Grizzly",destinate,rotation,world,store,1);
                break;
            case 1:
                spawnEntity("Bear_Grizzly",destinate,rotation,world,store,10);
                break;
            case 2:
                addItem(player,"lucky_block",1,store);
                break;
            case 3:
                //NOTHING
                break;
            case 4:
                addItem(player,"lucky_block",4,store);
                break;
            case 5:
                addItem(player,"Ingredient_Bar_Silver",1,store);
                break;
            case 6:
                addItem(player,"Ingredient_Bar_Gold",2,store);
                break;
            case 7:
                addItem(player,"Ingredient_Tree_Sap",50,store);
                break;
            case 8:
                addItem(player,"Ingredient_Bar_Iron",6,store);
                break;
            case 9:
                addItem(player,"Ingredient_Bar_Bronze",4,store);

                break;
            case 10:
                addItem(player,"Ingredient_Leather_Dark",4,store);

                break;
            case 11:
                //NOTHING
                break;
            case 12:
                addItem(player,"Potion_Health",2,store);
                break;
            case 13:
                addItem(player,"Tool_Repair_Kit_Iron",1,store);
                break;
            case 14:
                addItem(player,"Ingredient_Poop",64,store);
                break;
            case 15:
                addItem(player,"Wood_Drywood_Planks",32,store);
                break;
            case 16:
                addItem(player,"Wood_Oak_Trunk",50,store);
                break;
            case 17:
                addItem(player,"Upgrade_Backpack_1",1,store);
                break;
            case 18:
                addItem(player,"Rubble_Aqua",20,store);
                break;
            case 19:
                addItem(player,"Rubble_Ice",20,store);
                break;
            case 20:
                addItem(player,"Rock_Stone_Brick_Decorative",20,store);
                break;
            case 21:
                addItem(player,"Rock_Salt",10,store);
                break;
            case 22:
                addItem(player,"Rock_Gem_Diamond",2,store);
                break;
            case 23:
                addItem(player,"Rock_Bedrock",1,store);
                break;
            case 24:
                addItem(player,"Armor_Cloth_Cindercloth_Chest",1,store);
                break;
            case 25:
                addItem(player,"Armor_Cloth_Cindercloth_Hands",1,store);
                break;
            case 26:
                addItem(player,"Armor_Cloth_Cindercloth_Head",1,store);
                break;
            case 27:
                addItem(player,"Armor_Cloth_Cindercloth_Legs",1,store);
                break;
            case 28:
                spawnEntity("Skeleton_Fighter",destinate,rotation,world,store,3);
                break;
            case 29:
                spawnEntity("Zombie",destinate,rotation,world,store,3);
                break;
            case 30:
                spawnEntity("Skeleton_Archmage",destinate,rotation,world,store,1);
                break;
            case 31:
                spawnEntity("Cactee",destinate,rotation,world,store,1);

                break;
            case 32:
                spawnEntity("Chick",destinate,rotation,world,store,3);

                break;
            case 33:
                spawnEntity("Catfish",destinate,rotation,world,store,3);

                break;
            case 34:
                spawnEntity("Corgi",destinate,rotation,world,store,1);

                break;
            case 35:
                spawnEntity("Outlander_Marauder",destinate,rotation,world,store,2);

                break;
            case 36:
                spawnEntity("Snake_Cobra",destinate,rotation,world,store,3);

                break;
            case 37:
                spawnEntity("Temple_Mithril_Guard",destinate,rotation,world,store,3);

                break;
            case 38:
                spawnEntity("Bat",destinate,rotation,world,store,3);

                break;
            case 39:
                spawnEntity("Wolf_Black",destinate,rotation,world,store,4);

                break;
            case 40:
                addItem(player,"Armor_Bronze_Chest",1,store);
                break;
            case 41:
                addItem(player,"Armor_Bronze_Hands",1,store);
                break;
            case 42:
                addItem(player,"Armor_Bronze_Head",1,store);
                break;
            case 43:
                addItem(player,"Armor_Bronze_Legs",1,store);
                break;
        }

        //if(SelectionManager.isPositionInsideSelection(blockPosition)) {
            //breakBlockEvent.setCancelled(true);
        //}

    }

    @Override
    public Query<EntityStore> getQuery() {
        return Archetype.empty();
    }
}