#include "Bus.hpp"

Bus::Bus(){
	
	//Clear CPUram
	for(auto& i : CPUram){
		i = 0x00;
	}
	
	cpu.ConnectBus(this);
}

Bus::~Bus(){
	
}

void Bus::cpuWrite(uint16_t addr, uint8_t data){
	
	//Cartridge can hijack write
	if(cart->cpuWrite(addr,data)){
		
	} else if(addr >= 0x0000 &&addr <= 0x1FFF){
		CPUram[addr & 0x07FF] = data;
	} else if(addr >= 0x2000 && addr <= 0x3FFF){ //PPU address range (reduced with mirroring)
		ppu.cpuWrite(addr & 0x0007, data);
	} else if(addr >= 0x4016 && addr <= 0x4017){ //Controller
		controller_state[addr & 0x0001] = controller[addr & 0x0001];
	} else if(addr == 0x4014){ //Init DMA
		dma_page = data;
		dma_addr = 0x00;
		dma_transfer=true;
	}
	
}

uint8_t Bus::cpuRead(uint16_t addr, bool readOnly){
	uint8_t data = 0x00;
	
	//Cartridge can hijack write
	if(cart->cpuRead(addr,data)){
		
	}else if(addr >= 0x0000 &&addr <= 0x1FFF){
		data =  CPUram[addr & 0x07FF];
	} else if(addr >= 0x2000 && addr <= 0x3FFF){ //PPU address range (reduced with mirroring)
		data = ppu.cpuRead(addr & 0x0007, readOnly);
	} else if(addr >= 0x4016 && addr <= 0x4017){ //Controller
		data = (controller_state[addr & 0x0001] & 0x80) > 0;
		controller_state[addr & 0x0001] <<=1;
	}
	
	return data;
}

void Bus::insertCartridge(const std::shared_ptr<Cartridge>& cartridge){
	this->cart = cartridge;
	ppu.ConnectCartridge(cartridge);
}

void Bus::reset(){
	cart->reset();
	cpu.reset();
	ppu.reset();
	nSystemClockCounter = 0;
}

void Bus::clock(){
	
	ppu.clock();
	
	if(nSystemClockCounter %3 == 0){
		if(dma_transfer == true){
			if(dma_dummy == true){
				if(nSystemClockCounter %2 == 1){
					dma_dummy = false;
				}
			} else {
				if(nSystemClockCounter %2 == 0){
					dma_data = cpuRead(dma_page << 8 | dma_addr);
				} else {
					ppu.pOAM[dma_addr] = dma_data;
					dma_addr++;
					
					if(dma_addr == 0x00){
						//Wrapped around
						dma_transfer = false;
						dma_dummy = true;
					}
				}
			}
		} else {
			cpu.clock();
		}
		
	}
	
	if(ppu.nmi == true){
		ppu.nmi = false;
		cpu.nmi();
	}
	
	nSystemClockCounter++;
	
} //Perform 1 little tick
