#ifndef CARTRIDGE_HPP
#define CARTRIDGE_HPP

#include <vector>
#include <cstdint>
#include <memory>
#include <fstream>
#include <string>

#include "Mapper_000.hpp"

//Contains the data and address pins for the PPU and CPU, contains pattern memory (a kind of sprite sheet info).
class Cartridge{
	private:
		std::vector<uint8_t> vPRGMem;
		std::vector<uint8_t> vCHRMem;
		
		uint8_t nMapperID = 0; //Which mapper
		
		//Which banks
		uint8_t nPRGBanks= 0;
		uint8_t nCHRBanks= 0;
		
		std::shared_ptr<Mapper> pMapper;
		
		
	public:
		Cartridge(const std::string& sFileName);
		~Cartridge();
		
		enum MIRROR{
			HORIZONTAL,
			VERTICAL,
			ONSCREEN_LO,
			ONSCREEN_HI,
		} mirror = HORIZONTAL;
		
		void reset();
		
		//Comms with main bus
		bool cpuRead(uint16_t addr, uint8_t& data);
		bool cpuWrite(uint16_t addr, uint8_t data);
		
		//Comms with PPU bus
		bool ppuRead(uint16_t addr, uint8_t& data);
		bool ppuWrite(uint16_t addr, uint8_t data);
		
		
};

#endif