#ifndef CAMERA_HPP
#define CAMERA_HPP

#include "./math_vec.hpp"
#include "./math_ray.hpp"
#include <cmath>

class Camera{
	public:
		virtual ~Camera() {}
		
		virtual Ray makeRay(Vec2 point) const = 0;
};

class PerspectiveCamera: public Camera{
	protected:
		Point origin;
		Vec3 forward;
		Vec3 up;
		Vec3 right;
		
		double height;
		double width;
	
	public:
	
		PerspectiveCamera(Point origin, Vec3 target, Vec3 upguide, double fov, double aspectRatio);
		
		virtual Ray makeRay(Vec2 point) const;
	
	
		
	
};

#endif