#ifndef COLOR_HPP
#define COLOR_HPP

#include <cmath>

class Color{
	private:
	
	public:
		double r;
		double g;
		double b;
		
		Color();
		Color(double l);
		Color(double _r, double _g, double _b);
		
		virtual ~Color();
		
		void clamp(double min = 0.0, double max = 1.0);
		
		void applyGammaCorrection(double exposure, double gamma);
		
		Color& operator=(const Color& c);
		Color& operator+=(const Color& c);
		Color& operator*=(const Color& c);
		Color& operator*=(double f);
		
		Color operator/(double f) const {
			return Color(r/f, g/f, b/f);
		}
		
		Color(const Color&) = default;
};

inline Color operator+( const Color& c1, const Color& c2){
	return Color(c1.r + c2.r,c1.g + c2.g,c1.b + c2.b);
}

inline Color operator-( const Color& c1, const Color& c2){
	return Color(c1.r - c2.r,c1.g - c2.g,c1.b - c2.b);
}

inline Color operator*( const Color& c1, const Color& c2){
	return Color(c1.r * c2.r,c1.g * c2.g,c1.b * c2.b);
}

inline Color operator*( const Color& c1, double p){
	return Color(c1.r * p,c1.g * p,c1.b * p);
}

inline Color operator*(double p,const Color& c1){
	return Color(c1.r * p,c1.g * p,c1.b * p);
}

#endif