#include "./image.hpp"

#include <fstream>
#include <QImage>


Image::Image(int width, int height): width(width), height(height){
	data = new Color[width * height];
}

Image::~Image(){
	delete[] data;
}

int Image::getWidth() const{
	return width;
}

int Image::getHeight() const{
	return height;
}

Color* Image::getPixel(int x, int y){
	return data + (x + y * width);
}

void Image::saveImage(std::string filename, double exposure, double gamma) const{
	uchar* imgData = new uchar[4 * width * height];

	for (int x = 0; x < width; x++){
		
		for (int y = 0; y < height; y++){
			
			Color curColor = data[x + y * width];
			
			curColor.applyGammaCorrection(exposure, gamma);
			curColor.clamp();

			imgData[4 * (x + y * width) + 3] = 255; //Alpha
			imgData[4 * (x + y * width) + 2] = (uchar)(curColor.r * 255.0);
			imgData[4 * (x + y * width) + 1] = (uchar)(curColor.g * 255.0);
			imgData[4 * (x + y * width) + 0] = (uchar)(curColor.b * 255.0);
		}
	}

	QImage img(imgData, width, height, QImage::Format_RGB32);
	img.save(QString(filename.c_str()));

	delete[] imgData;
}