#include "./math_ray.hpp"

Ray::Ray(): origin(0.0,0.0,0.0), direction(), tMax(RAY_T_MAX){
	
}

Ray::Ray(const Ray& r): origin(r.origin), direction(r.direction), tMax(r.tMax){
	
}

Ray::Ray(const Point& _origin, const Vec3& _direction, double _tMax): origin(_origin), direction(_direction), tMax(_tMax){
	
}

Ray::~Ray(){
	
}

Ray& Ray::operator=(const Ray& r){
	origin = r.origin;
	direction = r.direction;
	tMax = r.tMax;
	
	return *this;
}

Point Ray::calculate(double t) const{
	return origin + direction*t;
}

//Intersections

Intersection::Intersection(): ray(), t(RAY_T_MAX), pShape(nullptr){
	normal = Vec3(0.0,1.0,0.0);
}

Intersection::Intersection(const Intersection& i): ray(i.ray), t(i.t), pShape(i.pShape), normal(i.normal){
	
}

Intersection::Intersection(const Ray& _ray): ray(_ray), t(_ray.tMax), pShape(nullptr){
	normal = Vec3(0.0,1.0,0.0);
}

Intersection::~Intersection(){
	
}

Intersection& Intersection::operator=(const Intersection& i){
	ray = i.ray;
	t = i.t;
	pShape = i.pShape;
	normal = i.normal;
	
	return *this;
}

bool Intersection::intersected() const{
	return (pShape != nullptr); //Check if we intersected something, or a shape we intersected exists or not.
}

Point Intersection::position() const{
	return ray.calculate(t);
}
