#include "./scene.hpp"

void Scene::setExposure(double d){
	exposure = d;
}

void Scene::setAmbientLightStrength(double d){
	ambient_light_strength = d;
}

double Scene::getExposure() const{
	return exposure;
}

double Scene::getAmbientLightStrength() const{
	return ambient_light_strength;
}

Scene::Scene(){
	exposure=0.4;
	ambient_light_strength=4.0;
}

void Scene::add(Shape* elem){
	contents.addShape(elem);
}

void Scene::rayTrace(Image& image, Camera* camera){
	Shape* scene = &contents;
	
	std::list<Shape*> lights;
	scene->findLights(lights);
	
	for(int x = 0; x<image.getWidth();x++){
		for(int y = 0; y<image.getHeight();y++){
			Vec2 screenCoord((2.0*x) / image.getWidth() -1.0, (-2.0*y) / image.getHeight() + 1.0);
			
			Ray ray = camera->makeRay(screenCoord);
			Color* curPixel = image.getPixel(x,y);
			
			Intersection intersection(ray);
			
			if(scene->intersect(intersection) == true){
				if(intersection.pShape->isLight()) {
					*curPixel = dynamic_cast<Light*>(intersection.pShape)->emitted();
					//*curPixel = shade(intersection, lights,scene);
				} else {
					//*curPixel = intersection.color;
					*curPixel = lambertShade(intersection, lights,*this);
					//*curPixel = phongShade(intersection, lights,ray,*this);
					
				}
			} else {
				*curPixel = Color(0.0);
			}
			
			
		}
	}
}