#include "./lambert.hpp"
#include "../scene.hpp"

#define PHONG_COSTANT 4.0
#define GLOBAL_SHININESS 0.4

Color phongShade(const Intersection& isect, const std::list<Shape*>& lights,Ray& cam_ray, const Scene& mainScene){
	
	Shape* scene = const_cast<ShapeSet*>(&mainScene.contents);
	
    Color result(isect.color*mainScene.getAmbientLightStrength());

    //The material of the intersected surface.
    Color surfaceColor = isect.color;  

    for (Shape* shapeLight : lights) {
        Light* light = dynamic_cast<Light*>(shapeLight);
		
        if (!light){
			continue;
		}

        Vector toLight = light->getPosition() - isect.position();
        double distance2 = toLight.length_squared();
        toLight.normalize();
		
		//N dot L = normal face dot the vector to the light.

        //Shading
        Ray shadowRay(isect.position() + isect.normal * SHADOW_BIAS, toLight);
        Intersection shadowIsect(shadowRay);
        if (scene->intersect(shadowIsect) && !shadowIsect.pShape->isLight()) {
            continue; // in shadow
        }

		//Apply diffuse shading
        double NdotL = std::max(0.0, dot(isect.normal*toLight*PHONG_COSTANT, cam_ray.direction)); //If negative, then there is shadows
        
		(void)NdotL;
		(void)distance2;
		
        Color contribution = surfaceColor * light->emitted() * (std::pow(NdotL, GLOBAL_SHININESS)/distance2);

        result += contribution;
    }
	
	//result=ReinhardMapping(result);
	result=FilmicMapping(result,mainScene.getExposure());
	

    return result;
}