#ifndef SHAPE_HPP
#define SHAPE_HPP

#include "./math_vec.hpp"
#include "./math_ray.hpp"
#include "./color.hpp"
#include <cmath>
#include <vector>
#include <list>

//Generic shape, just a template
class Shape{
	public:
	
		virtual ~Shape() {}
		
		virtual bool intersect(Intersection& intersection) = 0; //Goes and finds where the shape intersects.
		virtual bool doesIntersect(const Ray& ray) = 0; //Checks if the ray hits the shape or not.
		
		virtual bool sampleSurface(const Point& refPosition, const Vec3& refNormal, double u1, double u2, double u3, Point& outPosition, Vec3& outNormal, double& outPDF) const;
		
		virtual double surfaceAreaPDF() const{return 0.0f;}
		
		virtual Vec3 getPosition() const {return Vec3(0.0,0.0,0.0);}
		
		virtual double pdfSA(
		const Point& refPosition,
		const Vec3& refNormal,
		const Point& surfPosition,
		const Vec3& surfNormal) const;

		// Finds all lights within the scene
		virtual void findLights(std::list<Shape*>& outLights) { (void)outLights;}

		virtual bool isLight() const { return false; }
	
	private:
	
};

//Intersect will be tested on all sub shapes.
class ShapeSet: public Shape{
	protected:
		std::vector<Shape*> shapes;
		
	public:
		ShapeSet();
		
		virtual ~ShapeSet();
		
		void addShape(Shape* shape);
		
		void findLights(std::list<Shape*>& outLights);
		
		virtual Vec3 getPosition() const {return Vec3(0.0,0.0,0.0);}
		
		virtual bool intersect(Intersection& intersection); //Goes and finds where the shape intersects.
		virtual bool doesIntersect(const Ray& ray); //Checks if the ray hits the shape or not.
	
	private:
		
};

typedef Shape Group;

class Plane: public Shape{
	protected:
		Point position;
		Vec3 normal;
		Color color;
		
	public:
		Plane(const Point& _position, const Vec3& _normal, const Color& _color = Color(1.0,1.0,1.0));
		
		virtual ~Plane();
		
		virtual Vec3 getPosition() const {return position;}
		
		virtual bool intersect(Intersection& intersection); //Goes and finds where the shape intersects.
		virtual bool doesIntersect(const Ray& ray); //Checks if the ray hits the shape or not.

};

class Sphere: public Shape{
	protected:
		Point center;
		double radius;
		Color color;
		
	public:
		Sphere(const Point& _center, double _radius, const Color& _color = Color(1.0,1.0,1.0));
		
		virtual ~Sphere();
		
		virtual bool intersect(Intersection& intersection); //Goes and finds where the shape intersects.
		virtual bool doesIntersect(const Ray& ray); //Checks if the ray hits the shape or not.
		
		virtual Vec3 getPosition() const {return center;}
	
};

#endif