#ifndef GLOBAL_CONSTANTS_HPP
#define GLOBAL_CONSTANTS_HPP

#define GRAPHICS_PATH "./assets/textures/"
#define GRAPHICS_ELECTRONICS_PATH "electronics/"
#define GRAPHICS_DIGITAL_PATH "digital/"

#define DEFAULT_SIZE_X 100
#define DEFAULT_SIZE_Y 100

#define WIRE_COLOR IM_COL32(0, 0, 0, 255)
#define OVERLAY_TEXT_COLOR IM_COL32(128, 128, 255, 255)
#define OVERLAY_TEXT_OFFSET 2.0 //How much under the components the text is offsetted to.

#define OVERLAY_FONT_SIZE_SCALE 1.5f

#define HIGHLIGHT_COLOR IM_COL32(255, 0, 0, 255)
#define PORT_RADIUS 8.0f

#define AABB_COLOR IM_COL32(255, 255, 0, 255)

#define ECF_FILE_EXTENSION ".ecf" //Electrical component file
#define DCF_FILE_EXTENSION ".dcf" //Digital component file
#define PCB_FILE_EXTENSION ".pcb"

#define ELECTRONICS_COMPONENTS_DIRECTORY "assets/components/electronics/"
#define DIGITAL_COMPONENTS_DIRECTORY "assets/components/digital/"

inline constexpr ImVec4 FOREGROUND_COLOR{1.0f, 1.0f, 1.0f, 1.0f};
inline constexpr ImVec4 GRID_COLOR{0.7f, 0.7f, 0.7f, 1.0f};

//PCB

#define PCB_COLOR IM_COL32(30, 97, 44, 255)
#define PCB_ARTIFACT_COLOR IM_COL32(81, 157, 64, 255)
#define COPPER_COLOR IM_COL32(184, 115, 51, 255)

inline constexpr float PIN_PITCH_MM      = 2.54f;
inline constexpr float VIA_DRILL_MM      = 0.8f;   // typical THT
inline constexpr float VIA_DIAMETER_MM   = 1.6f;
inline constexpr float TRACE_WIDTH_MM    = 0.25f;  // ~10 mil
inline constexpr float CLEARANCE_MM      = 0.2f;

inline constexpr float VIA_CLEARANCE_MM = 0.3f;

#define MAX_CELL_SIZE 300

#define CUTOUT_COLOR IM_COL32(64, 64, 64, 255)
#define PCB_BORDER_COLOR IM_COL32(255, 255, 0, 255)

#define PCB_ARTIFACT_SCALE 2.0
#define PCB_ARTIFACT_SIZE 3.0

#define WIRE_COLOR_LAYER2 IM_COL32(0, 0, 255, 255)
#define WIRE_COLOR_LAYER1 IM_COL32(255, 0, 0, 255)

#define PCB_HIGHLIGHT_COLOR IM_COL32(255, 200, 0, 255)

#endif