#ifndef CONTROL_DATA_HPP
#define CONTROL_DATA_HPP

#include "electronics_visual_model.hpp"

struct ControlData{
	public:
		bool needsPortHighlight = false;
		bool show_validated = false;
		
		ElectricalComponent* forWire1 = nullptr;
		ElectricalComponent* forWire2 = nullptr;
		Port* p1 = nullptr;
		Port* p2 = nullptr;
		
		std::vector<ImVec2> currentCutout;
		bool placingCutout = false;
		
		int phasesWiring = 0;
		
		double rotationValue = 0.0f;
		
		bool placing_locked = false;
		
		size_t selectedToolId = 0;
		
		bool snap_to_grid = false;
		bool show_overlay_text = true;
		
		bool screen_updated = false;
		
		ImDrawList* draw_list = nullptr;
		
		ControlData();
		
		int cell_size = 20;
};

#endif