#include "control_window.hpp"

ControlWindow::ControlWindow(int _window_width, int _window_height, const char* _window_title): RenderWindow(_window_width, _window_height, _window_title) {
	glfwSetScrollCallback(getWindow(), scroll_callback);
	
	
	
	
}
ControlWindow::~ControlWindow(){
	if(page != nullptr){
		delete page;
		page = nullptr;
	}
	
	delete d;
}

void ControlWindow::init(){
	set_background_color(FOREGROUND_COLOR);
	
	d = new ControlData();
	d->draw_list = ImGui::GetBackgroundDrawList();
	
	
	switchTo(0);
	
	
	//glfwSetKeyCallback(getWindow(), KeyCallback);
	
}

void ControlWindow::switchTo(int windowId){
	
	switchedType = windowId;
	
	if(page != nullptr){
		delete page;
		page = nullptr;
	}
	
	switch(windowId){
		case 0: //Electrical
			page = new ElectronicsPage();
			break;
		case 1: //Digital
			page = new DigitalPage();
			break;
		case 2: //PCB
			page = new PCBPage();
			break;
	}
	
	page->preInit();
	page->setControlData(d);
	page->initialize();
	page->loadTexturesFromMainCollection();
}

void ControlWindow::handleMovement(float delta_time){
	d->screen_updated= false;
	
	float move_speed2 = InputState::getInstance()->move_speed;
	if(glfwGetKey(getWindow(), GLFW_KEY_A) == GLFW_PRESS){
		offset_x += move_speed2*delta_time;
		d->screen_updated=true;
	}
	
	if(glfwGetKey(getWindow(), GLFW_KEY_D) == GLFW_PRESS){
		offset_x -= move_speed2*delta_time;
		d->screen_updated=true;
	}
	
	if(glfwGetKey(getWindow(), GLFW_KEY_W) == GLFW_PRESS){
		offset_y += move_speed2*delta_time;
		d->screen_updated=true;
	}
	
	if(glfwGetKey(getWindow(), GLFW_KEY_S) == GLFW_PRESS){
		offset_y -= move_speed2*delta_time;
		d->screen_updated=true;
	}
	
	glfwGetCursorPos(getWindow(), &InputState::getInstance()->mouse_x, &InputState::getInstance()->mouse_y);
	InputState::getInstance()->updateGridSnap();

	// --- Mouse buttons ---
	InputState::getInstance()->left_mouse_down  = (glfwGetMouseButton(getWindow(), GLFW_MOUSE_BUTTON_LEFT) == GLFW_PRESS);
	InputState::getInstance()->right_mouse_down = (glfwGetMouseButton(getWindow(), GLFW_MOUSE_BUTTON_RIGHT) == GLFW_PRESS);
	
	if(InputState::getInstance()->left_mouse_down == true || InputState::getInstance()->right_mouse_down == true){
		d->screen_updated=true;
	}
	
	InputState::getInstance()->screenoffset_x = offset_x;
	InputState::getInstance()->screenoffset_y = offset_y;
	
	d->needsPortHighlight = false;
	
	page->handleInteractions();
	
}

//rgba format for color
void ControlWindow::draw_cell(int off_x, int off_y, int x, int y, ImVec4 color,bool filled){
	ImVec2 top_left = ImVec2(off_x+x*d->cell_size, off_y+y*d->cell_size);
	ImVec2 bottom_right = ImVec2(off_x+(x+1)*d->cell_size, off_y+(y+1)*d->cell_size);
	
	const ImU32 color_int = ImColor(color);
	ImDrawList* draw = ImGui::GetBackgroundDrawList();
	if(filled == true){
		draw->AddRectFilled(top_left,bottom_right,color_int);
	} else {
		draw->AddRect(top_left, bottom_right, color_int);
	}
}

void ControlWindow::tick(){
	
	
	float delta_time = io->DeltaTime;
	
	handleMovement(delta_time);
	
	if(d->screen_updated == true){
		page->electronics.update(offset_x,offset_y);
		
	}
	
	InputState::getInstance()->tryDragElement();
	
	//draw
	
	cell_count_X = getWidth()/d->cell_size +2;
	cell_count_Y = getHeight()/d->cell_size +2;
	
	int Ioffset_x = static_cast<int>(offset_x)%d->cell_size -d->cell_size;
	int Ioffset_y = static_cast<int>(offset_y)%d->cell_size -d->cell_size;
	
	for(int x= 0; x<cell_count_X;x++){
		for(int y= 0; y<cell_count_Y;y++){
			draw_cell(Ioffset_x,Ioffset_y,x,y, GRID_COLOR, false);
		}
	}
	/*InputState::getInstance()->oAX =
		static_cast<double>(posmod(static_cast<int>(offset_x), d->cell_size) - d->cell_size);

	InputState::getInstance()->oAY =
		static_cast<double>(posmod(static_cast<int>(offset_y), d->cell_size) - d->cell_size);*/

	/*if(d->draw_list != nullptr){
		
	}*/
	ImDrawList* draw_list = ImGui::GetBackgroundDrawList();
	page->electronics.draw(d->show_overlay_text,draw_list,offset_x,offset_y,getWidth(),getHeight(),d->needsPortHighlight);

	ImGui::SetNextWindowSize(window_size);
	ImGui::SetNextWindowPos(ImVec2(getWidth() - window_size.x, 0));

	ImGui::Begin("Views");
	ImGui::Text("Select from views:");
	if (ImGui::Button("Electrical schematic editor")) {
		switchTo(0);
	}
	ImGui::Separator();
	if (ImGui::Button("Digital schematic editor")) {
		switchTo(1);
	}
	ImGui::Separator();
	if (ImGui::Button("PCB editor")) {
		switchTo(2);
	}
	ImGui::Separator();
	
	ImGui::Text("Grid settings:");

	ImGui::PushItemWidth(100);
	if (ImGui::InputInt("Cell Size (mm)", &d->cell_size)) {
		if (d->cell_size < 1){
			d->cell_size = 1;
		}
		
		if (d->cell_size > MAX_CELL_SIZE){
			d->cell_size = MAX_CELL_SIZE;
		}
		
		InputState::getInstance()->snap_grid_size = d->cell_size;
	}
	ImGui::PopItemWidth();
	ImGui::Separator();
	
	ImGui::End();
	
	page->drawGUI(clear_color,io->Framerate);
}