#include "exceptions.hpp"

EditorException::EditorException(const char* msg): message(msg) {
	
}

const char* EditorException::what() const noexcept {
    return message.c_str();
}


void logError(const std::string& msg){
	std::cerr << "ERROR | " << msg << std::endl;
	throw new EditorException(msg.c_str());
}

void logWarn(const std::string& msg){
	std::cout<< "WARNING | " << msg << std::endl;
}