#ifndef INPUT_STATE_HPP
#define INPUT_STATE_HPP

#include "world_pieces/electronics/node.hpp"

#include <iostream>
#include <mutex>

class InputState{
    private:
        /* Here will be the instance stored. */
        

        /* Private constructor to prevent instancing. */
        InputState();

    public:

		static InputState* instance;
		
		static InputState* getInstance(){
			if (instance == nullptr){
				instance = new InputState();
			}

			return instance;
		}
		
		float offset_x = 0.0f;
		float offset_y = 0.0f;
		float move_speed = 200.0f;

		// Mouse
		double mouse_x = 0.0;
		double mouse_y = 0.0;
		bool left_mouse_down = false;
		bool right_mouse_down = false;
		double scroll_x = 0.0;
		double scroll_y = 0.0;
		
		bool dragMode = true;
		
		double screenoffset_x = 0.0;
		double screenoffset_y = 0.0;
		
		double selfOX =0.0;
		double selfOY =0.0;
		
		int snap_grid_size = 1; //IF 1 then nothing happens.
		
		Node* dragged2DElement = nullptr;
		
		bool dragging =false;
		
		void tryDragElement();
		
		void updateGridSnap();
};

#endif