#ifndef PCB_MENU_HPP
#define PCB_MENU_HPP

#include "logical_page.hpp"
#include <vector>

#include "../world_pieces/PCB/trace.hpp"
#include "../world_pieces/PCB/via.hpp"
#include "../world_pieces/PCB/cutout.hpp"
#include "../world_pieces/PCB/board.hpp"

#include "../file_io/board_loader.hpp"


class PCBPage: public LogicalPage{
	private:
		Board* board = nullptr;
		
		BoardLoader board_loader;
		
		bool show_comp_window = false;
		
		bool placingTrace =false;
		bool traceStart = true;
		
		Trace currentTrace;
		
		//TEMP variables
		double _width_mm=0.25;
		int _layer=0;
		
		double drill=40.8;
		double diam=50.6;
		
		const char* layers[2] = { "Foreground (0)", "Background (1)" };
		
	public:
		PCBPage();
		
		~PCBPage();
	
		void initialize() override;
	
		void loadTextureForComponent(const char* filepath) override;
		
		
		void drawGUI(ImVec4& clear_color,float frate) override;
		
		void handleInteractions() override;
		
};

#endif