#include "logical_page.hpp"


LogicalPage::~LogicalPage(){
	componentTextures.clear();
	electronics.clear();
}

void LogicalPage::setControlData(ControlData* _d){
	d = _d;
}

void LogicalPage::preInit(){
	mainCollection = ElectricalComponentCollection("root");
	sceneSaveable = ElectricalComponentCollection("scene");
	electronics = ElectricalNodeCollection(nullptr);
}

void LogicalPage::loadTexturesFromMainCollection(){
	for(size_t i=0;i<mainCollection.components.size();i++){
		loadTextureForComponent(mainCollection.components[i]->texture.c_str());
	}
}
