#ifndef PCB_BOARD_HPP
#define PCB_BOARD_HPP

#include "trace.hpp"
#include "via.hpp"
#include "cutout.hpp"
#include "../../input_state.hpp"

struct Board {
	private:
		ImVec2 buffer;
		ImVec2 bufferEnd;
		
	public:
		ImVec2 position;
		
		ImVec2 size;
		std::vector<Trace> traces;
		std::vector<Via> vias;
		std::vector<Cutout> cutouts;
		
		
		Board();
		
		~Board();
		
		void draw(bool show_overlay_text, ImDrawList* draw_list,double offX, double offY,int cell_size);
		
		void update(double oX, double oY);
		
		void checkDrag();
		
		void checkDelete(Node* c);
	
};

#endif