#include "cutout.hpp"
	
void Cutout::setPosition(double x, double y) {
    if (polygon.empty()) {
		return;
	}

    ImVec2 delta(x - polygon[0].x, y - polygon[0].y);

    for (auto& p : polygon) {
        p.x += delta.x;
        p.y += delta.y;
    }
}
	
void Cutout::update(double offX, double offY) {
    if (polygon.empty()){
        return;
	}

    double _minX = polygon[0].x + offX;
    double _minY = polygon[0].y + offY;
    double _maxX = polygon[0].x + offX;
    double _maxY = polygon[0].y + offY;

    for (size_t i = 1; i < polygon.size(); ++i) {
        double x = polygon[i].x + offX;
        double y = polygon[i].y + offY;

        if (x < _minX){
			_minX = x;
		}
			
        if (y < _minY){
			_minY = y;
		}
			
        if (x > _maxX){
			_maxX = x;
		}
			
        if (y > _maxY){
			_maxY = y;
		}
    }

    bbox.minX = _minX;
    bbox.minY = _minY;
    bbox.maxX = _maxX;
    bbox.maxY = _maxY;
}