#ifndef BASE_COMPONENT_HPP
#define BASE_COMPONENT_HPP

#include <memory>
#include <unordered_set>
#include <vector>
#include <iostream>
#include <cmath>
#include <glm/glm.hpp>
#include <Eigen/Dense>


#include "electric_utils.hpp"

#include "port.hpp"
#include "node.hpp"


#include <cmath>
#include "../../file_io/electrical_serializable.hpp"

class CircuitSimulation;

class ElectricalComponent: public Node{ //Will hold the ports, and attributes	
	protected:
		
		std::vector<ImVec2> portOffsets;
		size_t required_ports;
		
		int id;
		bool has_name = false;
		
		double lastCurrent = 0;
		double lastPower = 0;
		double lastVoltage = 0;
		
		double rotation =0.0;
		
		std::string stats = "-";
		
	public:
		
		void setLastVoltage(double v);
	
		ElectricalComponent();
		
		std::vector<Port*> ports;
	
		CustomElectricalComponent* serializedRef = nullptr;
	
		void setOffsets(const std::vector<ImVec2>& os);
		
		void setPosition(double x, double y) override;
	
		const std::vector<Port*>& getPorts() const;
		
		void setRotation(double deg);
		
		void setSerializedRef(CustomElectricalComponent* _serializedRef);
		
		int getId() const;
		
		virtual void setSimulatedString();
		
		virtual bool isGND() const;
		
		virtual bool isVoltageSource() const;
		
		virtual bool isCurrentSource() const;
		
		void setName(const std::string& n);
		
		//const std::string& getName() const;
		
		Port* getNearestPort(double x, double y);
		
		void debugPrint() const;
		const char* getStats() const;
	
		void addPort();
		
		void setRequiredPorts(size_t num);
		
		Port* getPort(size_t idx);
		
		virtual ~ElectricalComponent();
		
		virtual void stamp(CircuitSimulation& c) = 0;
		
		virtual void updateCurrentAndPower(const CircuitSimulation& c)=0;
		
		double getCurrent() const;
		
		double getPower() const;
		double getVoltage() const;
};

#endif