#include "capacitor.hpp"

Capacitor::Capacitor(double cap) : C(cap) {
	setRequiredPorts(2);
	setName("Capacitor_C" + std::to_string(C));
}

void Capacitor::stamp(CircuitSimulation& c) {
	// For DC analysis, capacitor is open circuit so do nothing
}

void Capacitor::updateCurrentAndPower(const CircuitSimulation& c) {
	double V = ports[0]->net->voltage - ports[1]->net->voltage;
	lastCurrent = 0;      // DC current = 0
	lastPower = 0;
	lastVoltage = V;
}
