#include "current_source.hpp"

CurrentSource::CurrentSource(double cur){
	current=cur;
	setRequiredPorts(2); // + and -
	setName("CurrentSource");
}

bool CurrentSource::isCurrentSource() const{
	return true;
}

void CurrentSource::stamp(CircuitSimulation& c) {
	int n1 = c.getNodeIndex(ports[0]->net); //+
	int n2 = c.getNodeIndex(ports[1]->net); //-

	if (n1 != GND_INDEX){
		c.b[n1] -= current; // current leaving n1
	}
	
	if (n2 != GND_INDEX){
		c.b[n2] += current; // current entering n2
	}
}

void CurrentSource::updateCurrentAndPower(const CircuitSimulation& c){
	lastCurrent = current;
	double Vplus = ports[0]->net->voltage;
	double Vminus = ports[1]->net->voltage;
	lastPower = (Vplus - Vminus) * lastCurrent; // V * I
	lastVoltage =(Vplus - Vminus);
}
