#ifndef CURRENT_SOURCE_HPP
#define CURRENT_SOURCE_HPP

#include "base_component.hpp"
#include "port.hpp"
#include "net.hpp"
#include "../../world_simulators/circuit_simulation.hpp"

class CurrentSource: public ElectricalComponent{
	private:
		double current = 0.2;
	public:
		CurrentSource(double cur);
		
		bool isCurrentSource() const override;
		
		void stamp(CircuitSimulation& c) override;
		
		void updateCurrentAndPower(const CircuitSimulation& c) override;
};

#endif