#include "diode.hpp"


Diode::Diode() {
	setRequiredPorts(2);
	setName("Diode");
}

void Diode::stamp(CircuitSimulation& c) {
	
	//(small-signal approx) last voltage linearization
	double Vd = ports[0]->net->voltage - ports[1]->net->voltage;
	double Gd = (Is / Vt) * exp(Vd / (n * Vt)); // small-signal conductance
	double Id = Is * (exp(Vd / (n*Vt)) - 1) - Gd * Vd;

	int n1 = c.getNodeIndex(ports[0]->net);
	int n2 = c.getNodeIndex(ports[1]->net);

	if(n1 != GND_INDEX){
		c.A(n1,n1) += Gd;
	}
	
	if(n2 != GND_INDEX){
		c.A(n2,n2) += Gd;
	}
	
	if(n1 != GND_INDEX && n2 != GND_INDEX){
		c.A(n1,n2) -= Gd;
		c.A(n2,n1) -= Gd;
	}
	
	if(n1 != GND_INDEX){
		c.b[n1] -= Id;
	}
	
	if(n2 != GND_INDEX){
		c.b[n2] += Id;
	}
}

void Diode::updateCurrentAndPower(const CircuitSimulation& c) {
	double Vd = ports[0]->net->voltage - ports[1]->net->voltage;
	lastCurrent = Is * (exp(Vd / (n*Vt)) - 1);
	lastVoltage = Vd;
	lastPower = lastCurrent * Vd;
}
