#ifndef LOGICAL_PIN_HPP
#define LOGICAL_PIN_HPP

#include "base_component.hpp"
#include "port.hpp"
#include "net.hpp"
#include "../../world_simulators/circuit_simulation.hpp"

class LogicalPin: public ElectricalComponent {
	private:
		double voltageLevel;   // 0.0 = low, 3.3 = high
		double maxCurrent;     // current the pin can source/sink
	public:
		LogicalPin(double v = 0.0, double iLimit = 0.012);

		void stamp(CircuitSimulation& c) override;

		void setLevel(double v);

		void updateCurrentAndPower(const CircuitSimulation& c) override;
};

#endif