#ifndef OP_AMP_HPP
#define OP_AMP_HPP

#include "base_component.hpp"
#include "port.hpp"
#include "net.hpp"
#include "../../world_simulators/circuit_simulation.hpp"

class OpAmp: public ElectricalComponent {
	private:
		double gain = 1e6; // very high open-loop gain
		int k_val = 0;     // extra variable for output
		
	public:
		OpAmp(double A = 1e6);

		void stamp(CircuitSimulation& c) override;

		void updateCurrentAndPower(const CircuitSimulation& c) override;
};

#endif