#include "voltage_source.hpp"

VoltageSource::VoltageSource(double v){
	voltage = v;
	setRequiredPorts(2); // + and -
	setName("VoltageSource");
}

bool VoltageSource::isVoltageSource() const{
	return true;
}

void VoltageSource::stamp(CircuitSimulation& c) {
	assert(ports[0]);
	assert(ports[1]);
	assert(ports[0]->net);
	assert(ports[1]->net);

	int n1 = c.getNodeIndex(ports[0]->net); //+
	int n2 = c.getNodeIndex(ports[1]->net); //-
	k_val  = c.allocateExtraVariable(); // current

	if (n1 != GND_INDEX) {
		c.A(n1,k_val) += 1;
		c.A(k_val,n1) += 1;
	}
	
	if (n2 != GND_INDEX) {
		c.A(n2,k_val) -= 1;
		c.A(k_val,n2) -= 1;
	}

	c.b[k_val] += voltage;
}

void VoltageSource::updateCurrentAndPower(const CircuitSimulation& c){
	lastCurrent = c.x[k_val];
	lastVoltage = voltage;
	lastPower = voltage * lastCurrent; // V * I
}