#ifndef VOLTAGE_SOURCE_HPP
#define VOLTAGE_SOURCE_HPP

#include "base_component.hpp"
#include "port.hpp"
#include "net.hpp"
#include "../../world_simulators/circuit_simulation.hpp"

class VoltageSource: public ElectricalComponent{
	private:
		double voltage = 5.0;
		int k_val = 0;
	public:
		VoltageSource(double v);
		
		bool isVoltageSource() const override;
		
		void stamp(CircuitSimulation& c) override ;
		
		void updateCurrentAndPower(const CircuitSimulation& c) override;
};

#endif