#include <iostream>
#include <functional>
#include <utility>
#include <numeric>
#include <vector>
#include <algorithm>

struct Square {
    int operator()(int x) const {
        return x * x;
    }
};



int main() {
    
    auto square = [](int x) { return x * x; };
    
    Square sq;
    std::cout << sq(5) << std::endl; // 25
    std::cout << square(5) << std::endl; // 25
    
    //-----------------------------------------------------
    std::vector<int> v = {1, 2, 3, 4, 5};

    // std::transform = "map"
    std::transform(v.begin(), v.end(), v.begin(), square);

    // std::for_each = "foreach"
    std::function<void(int)> printFN = [](int x){ std::cout << x << " "; };
    std::for_each(v.begin(), v.end(),printFN);

    // std::accumulate = "reduce"
    int sum = std::accumulate(v.begin(), v.end(), 0);
    std::cout << "\nSum: " << sum << "\n";
    
    std::function<std::function<int(int)>(int)> make_multiplier =
    [](int factor){
        return [factor](int x){ return factor * x; };
    };
    
    auto triple = make_multiplier(3);
    std::cout << triple(7); // 21
    
    //-----------------------
    //1. egy std::vector<int>-ből kiszűri a páros számokat, megduplázza őket, majd kiszámítja az összegüket.
    v = {1, 2, 3, 4, 5};
    std::vector<int> v2;
    
    std::function<void(int)> pushIF = [&](int x){ if(x %2==0) {
        v2.push_back(x);
    } };
    
    
    std::for_each(v.begin(), v.end(),pushIF);
    //std::copy_if(v.begin(), v.end(), std::back_inserter(v2),
    //         [](int x){ return x % 2 == 0; }); //Ez is jó
     
    auto doubleIT = [](int n){return n*2;};

    std::transform(v2.begin(), v2.end(), v2.begin(), doubleIT);

    

    int sum2 = std::accumulate(v2.begin(), v2.end(), 0);
    std::cout << "\nSum: " << sum2 << "\n";
    
    //2.
    std::function<std::function<void(int)>(int)> make_square =
    [](int height){
        return [height](int width){
            for(int i=0;i<height;i++){
                for(int j=0;j<width;j++){
                    std::cout << '#';
                }
                std::cout << std::endl;
            }
        };
    };
    
    auto square_shape = make_square(3);
    square_shape(5);
    square_shape(10);
    
    return 0;
}