
import Mathlib

/--
Here
D: Input function domain
f: Outputs real value
a: A value in domain D
-/
-- In Real domain at the point a on function f
def continousAt (D: Set ℝ) (f : D → ℝ) (a: D) : Prop :=
  ∀ ε > 0, ∃ δ > 0, ∀ x : D,
    (|x.val - a.val| < δ → |f x - f a| < ε )

-- Checking for all points
def continousInAllPoints (D: Set ℝ) (f : D → ℝ) : Prop :=
  ∀ a : D, continousAt D f a

-- Some checks
-- Left open right open interval ]0,1[
#check continousInAllPoints (Set.Ioo 0 1) (fun _ => (5 : ℝ))

-- Left closed right open interval [0,1[
#check continousInAllPoints (Set.Ico 0 1) (fun _ => (5 : ℝ))
#check continousInAllPoints {x : ℝ | x > 0} (fun x => x.val + 1)

-- Non continous
-- #check continousInAllPoints {x : ℝ | x > 0 ∨ x < 0} (fun x => Int.floor x.val % (2 : Int))

-- Some actual proofs
theorem constantFunctionIsContAtAPoint (D : Set ℝ) (c : ℝ) (a : D) : continousAt D (fun _ ↦ c) a := by 
  dsimp [continousAt]
  intro ε hεbigger0
  exists 1
  simp only [one_pos, true_and]

  intro x _h_xδ_crit --|x - a| < δ =1
  simp only [sub_self, abs_zero] --zero < ε by assumption
  exact hεbigger0
