/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.blockchain;

import hu.afghangoat.blockchain.Transaction;
import java.util.Arrays;
import java.util.Objects;

public class Block {
    private int prevHash;
    private Transaction[] transactions;

    public Block(int prevHash, Transaction[] transactions) {
        this.prevHash = prevHash;
        this.transactions = transactions;
    }

    public Transaction[] getTransactions() {
        return this.transactions;
    }

    public void setTransactions(Transaction[] transactions) {
        this.transactions = transactions;
    }

    public int getPrevHash() {
        return this.prevHash;
    }

    public void setPrevHash(int prevHash) {
        this.prevHash = prevHash;
    }

    Block() {
    }

    public Block clone() {
        return new Block(this.prevHash, this.transactions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        return this.prevHash == block.prevHash && Objects.deepEquals(this.transactions, block.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.prevHash, Arrays.hashCode(this.transactions), this.transactions[0].getSource(), this.transactions[0].getScore());
    }
}

