/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.blockchain;

import hu.afghangoat.blockchain.Block;
import hu.afghangoat.blockchain.BlockComparator;
import hu.afghangoat.blockchain.Transaction;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

public class BlockChainHelper {
    private List<Block> blocks = new ArrayList<Block>();

    public BlockChainHelper(int initialHash) {
        this.addBlock("Genesis", -1, initialHash);
    }

    public boolean verifyHash() {
        System.out.println("Hash size: " + this.blocks.size());
        for (int i = 0; i < this.blocks.size() - 1; ++i) {
            Block current = this.blocks.get(i);
            Block next = this.blocks.get(i + 1);
            if (current.hashCode() != next.getPrevHash()) {
                System.out.println("Hash verification failed at i: " + i);
                return false;
            }
            System.out.println(current.hashCode() + " | " + next.getPrevHash());
        }
        return true;
    }

    public void clearEntries() {
        if (this.blocks.size() > 1) {
            this.blocks.subList(1, this.blocks.size()).clear();
        }
    }

    public void addBlock(String nameEntry, int score) {
        Transaction cur = new Transaction(nameEntry, score);
        int prevHashCode = this.blocks.get(this.blocks.size() - 1).hashCode();
        this.blocks.add(new Block(prevHashCode, new Transaction[]{cur}));
    }

    public void addBlock(String nameEntry, int score, int prevHashCode) {
        Transaction cur = new Transaction(nameEntry, score);
        this.blocks.add(new Block(prevHashCode, new Transaction[]{cur}));
    }

    public String toHTMLSorted(int topEntryCount) {
        int i;
        Object value = "<html><ul>";
        ArrayList<Block> sortedData = new ArrayList<Block>();
        for (i = 1; i < this.blocks.size(); ++i) {
            sortedData.add(this.blocks.get(i).clone());
        }
        Collections.sort(sortedData, new BlockComparator());
        Collections.reverse(sortedData);
        for (i = 0; i < Math.min(sortedData.size(), topEntryCount); ++i) {
            Transaction cur = ((Block)sortedData.get(i)).getTransactions()[0];
            value = (String)value + "<li><b> #" + (i + 1) + "</b>" + cur.getSource() + " - " + cur.getScore() + "</li>";
        }
        value = (String)value + "</ul></html>";
        return value;
    }

    public void addBlock(Transaction[] transactions, int hash) {
        this.blocks.add(new Block(hash, transactions));
    }

    public Transaction transactionFromString(String data) {
        String[] entries = data.split(":");
        return new Transaction(entries[1], Integer.parseInt(entries[3]));
    }

    public boolean saveToFile(String fileName) {
        try {
            File saveFile = new File(fileName);
            if (saveFile.createNewFile()) {
                System.out.println("File created: " + saveFile.getName());
            } else {
                System.out.println("File already exists, replacing it...");
            }
        }
        catch (IOException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
        try {
            FileWriter writer = new FileWriter(fileName);
            Object line_entry = "";
            for (int i = 1; i < this.blocks.size(); ++i) {
                int transactionSize = this.blocks.get(i).getTransactions().length;
                line_entry = (String)line_entry + Integer.toString(this.blocks.get(i).getPrevHash()) + "|" + transactionSize + "|";
                for (int j = 0; j < transactionSize; ++j) {
                    Transaction cur = this.blocks.get(i).getTransactions()[j];
                    line_entry = (String)line_entry + cur.toString() + "|";
                }
            }
            byte[] bytes = ((String)line_entry).getBytes("UTF-8");
            String encoded = Base64.getEncoder().encodeToString(bytes);
            writer.write(encoded);
            writer.close();
            System.out.println("Successfully wrote to the file.");
        }
        catch (IOException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
        return true;
    }

    public boolean loadFromFile(String fileName) {
        try {
            File fileForRead = new File(fileName);
            if (!fileForRead.exists()) {
                System.out.println("File does not exist: " + fileForRead.getAbsolutePath() + "! Creating empty save file.");
                return this.saveToFile(fileName);
            }
            Scanner myReader = new Scanner(fileForRead);
            this.clearEntries();
            while (myReader.hasNextLine()) {
                byte[] decoded = Base64.getDecoder().decode(myReader.nextLine());
                String cur_line = new String(decoded, StandardCharsets.UTF_8);
                String[] entries = cur_line.split("\\|");
                int transactionSize = entries.length;
                if (transactionSize == 0) {
                    System.out.println("Invalid/Corrupted scoreboard save file! Skipping...");
                    return false;
                }
                for (int i = 0; i < transactionSize / 3; ++i) {
                    int hash = Integer.parseInt(entries[i * 3]);
                    Transaction[] transactionsInLine = new Transaction[]{this.transactionFromString(entries[2 + i * 3])};
                    this.addBlock(transactionsInLine, hash);
                }
            }
            myReader.close();
            return true;
        }
        catch (FileNotFoundException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
            return false;
        }
    }
}

