/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.views;

import hu.afghangoat.ConfigParser;
import hu.afghangoat.LangParser;
import hu.afghangoat.exceptions.InvalidDistanceException;
import hu.afghangoat.exceptions.InvalidGoalPositionException;
import hu.afghangoat.helpers.FlatMapCoordinate;
import hu.afghangoat.helpers.FlatMapParser;
import hu.afghangoat.helpers.GPSCoordinate;
import hu.afghangoat.helpers.GPSReader;
import hu.afghangoat.simulators.MouseEventSimulator;
import hu.afghangoat.views.MainWindow;
import hu.afghangoat.views.ViewInterface;
import hu.afghangoat.widgets.BackButton;
import hu.afghangoat.widgets.FancyButton;
import hu.afghangoat.widgets.GradientPanel;
import hu.afghangoat.widgets.GuessMap;
import hu.afghangoat.widgets.ScrollableImage;
import hu.afghangoat.widgets.ScrollableImageFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom2.Element;

public class GamePanel
extends GradientPanel
implements ViewInterface,
ActionListener {
    private BackButton backBtn;
    private GuessMap map;
    JLabel guessLabel;
    JLabel pointsLabel;
    JLabel roundLabel;
    private JButton nextGameBtn;
    private FlatMapParser flatMapParser = new FlatMapParser();
    private String imgName = "1.jpg";
    private JPanel imageAndMapPanel;
    private int totalPoints = 0;
    private int currentRound = -1;
    public static final int MAX_ROUNDS = 5;
    private List<Element> currentEntries = new ArrayList<Element>();
    private ScrollableImageFrame imageLabel = null;
    private double mDist = 0.0;
    public static final double MAX_DISTANCE_WHERE_POINTS_COUNT = 100.0;
    private MainWindow mainEndWindow;

    public void startRound() throws InvalidGoalPositionException {
        this.currentRound = -1;
        this.totalPoints = 0;
        this.currentEntries = this.flatMapParser.getShuffledLocations(5);
        this.nextRound(0.0);
    }

    private int calculateFalloffPoints(double missedDistance) {
        if (missedDistance > 100.0) {
            return 0;
        }
        return (int)(100.0 - missedDistance);
    }

    private void nextRound(double missedDistance) throws InvalidGoalPositionException {
        block12: {
            this.nextGameBtn.setVisible(false);
            System.out.println("Preparing next round...");
            if (this.currentRound != -1) {
                this.totalPoints += this.calculateFalloffPoints(missedDistance);
            }
            if (this.pointsLabel != null) {
                System.out.println(LangParser.getLang("POINTS_LABEL") + ": " + this.totalPoints);
                this.pointsLabel.setText(LangParser.getLang("POINTS_LABEL") + ": " + this.totalPoints);
            }
            if (this.imageLabel == null) {
                System.out.println("Imagelabel is null. This should not occur.");
                return;
            }
            ++this.currentRound;
            if (this.roundLabel != null) {
                this.roundLabel.setText(LangParser.getLang("ROUNDS_LABEL") + ": " + this.currentRound + " / 5");
            }
            if (this.currentRound >= Math.min(5, this.currentEntries.size())) {
                this.endGame();
                return;
            }
            this.imgName = this.currentEntries.get(this.currentRound).getChild("ImageName").getText();
            GPSReader reader = new GPSReader();
            this.imageAndMapPanel.remove(this.imageLabel);
            this.imageLabel = new ScrollableImageFrame(new ScrollableImage(ConfigParser.getImagePath() + this.imgName, 400, 600));
            this.imageAndMapPanel.add(this.imageLabel);
            this.imageAndMapPanel.revalidate();
            this.imageAndMapPanel.repaint();
            if (ConfigParser.USES_GPS) {
                try {
                    System.out.println("Reading EXIF info...");
                    GPSCoordinate gps = reader.extractGps(new File(ConfigParser.getImagePath() + this.imgName));
                    if (gps != null) {
                        System.out.println("Latitude: " + gps.getGPSLatitude());
                        System.out.println("Longitude: " + gps.getGPSLongitude());
                        FlatMapCoordinate coords = gps.toFlatMapCoordinate();
                        this.map.setGoalPos(coords);
                        this.map.setMarkerTo(10.0, 10.0);
                        break block12;
                    }
                    System.out.println("No GPS data found.");
                }
                catch (Exception e) {
                    System.out.println("Failed to get EXIF info!");
                }
            } else {
                FlatMapCoordinate coords = this.flatMapParser.getOfflineCoordsForImg(this.imgName);
                if (coords == null) {
                    System.out.println("Failed to get coordinates for supplied image: " + this.imgName);
                } else {
                    this.map.setGoalPos(coords);
                }
            }
        }
        this.map.setMarkerTo(10.0, 10.0);
    }

    private void endGame() {
        if (this.mainEndWindow != null) {
            this.mainEndWindow.showScore(this.totalPoints);
            this.mainEndWindow.showView("ENDGAME");
        }
    }

    @Override
    public void langChanged() {
        this.backBtn.setText(LangParser.getLang("BACK"));
        this.guessLabel.setText(LangParser.getLang("GUESS_METERS"));
        this.nextGameBtn.setText(LangParser.getLang("NEXT_GAME"));
        this.pointsLabel.setText(LangParser.getLang("POINTS_LABEL"));
        this.roundLabel.setText(LangParser.getLang("ROUNDS_LABEL"));
    }

    private void guessed(double missedDistance) {
        if (this.map.isPlacedMarker()) {
            this.guessLabel.setText(missedDistance + "m");
            this.mDist = missedDistance;
            this.nextGameBtn.setVisible(true);
            this.map.repaint();
            MouseEventSimulator view_fixer = new MouseEventSimulator();
            view_fixer.simulateDrag(50, 50, 49, 49, this.map);
        }
    }

    public GamePanel(MainWindow mainWindow) {
        super(new GridBagLayout());
        this.mainEndWindow = mainWindow;
        this.imageAndMapPanel = new JPanel(new GridBagLayout());
        this.imageAndMapPanel.setOpaque(false);
        this.imageLabel = new ScrollableImageFrame();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.weightx = 1.0;
        gbc.weighty = 2.0;
        gbc.fill = 1;
        this.imageAndMapPanel.add((Component)this.imageLabel, gbc);
        GridBagConstraints guessUIGBC = new GridBagConstraints();
        guessUIGBC.gridx = 0;
        guessUIGBC.gridy = 0;
        guessUIGBC.gridwidth = 1;
        guessUIGBC.fill = 2;
        guessUIGBC.weightx = 1.0;
        guessUIGBC.anchor = 10;
        guessUIGBC.insets = new Insets(2, 2, 2, 2);
        JPanel guessUI = new JPanel(new GridBagLayout());
        this.guessLabel = new JLabel("GUESS_METERS");
        this.pointsLabel = new JLabel("POINTS_LABEL");
        this.roundLabel = new JLabel("ROUNDS_LABEL");
        this.map = new GuessMap(0.1);
        this.map.setGoalPos(10.0, 10.0);
        guessUIGBC.gridx = 0;
        guessUIGBC.weightx = 1.0;
        guessUIGBC.fill = 2;
        guessUIGBC.gridy = 0;
        guessUI.add((Component)this.roundLabel, guessUIGBC);
        guessUIGBC.gridy = 1;
        guessUI.add((Component)this.pointsLabel, guessUIGBC);
        guessUIGBC.gridy = 2;
        guessUI.add((Component)this.guessLabel, guessUIGBC);
        guessUIGBC.gridy = 3;
        guessUIGBC.fill = 1;
        guessUIGBC.weighty = 1.0;
        guessUI.add((Component)this.map, guessUIGBC);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.imageAndMapPanel.add((Component)guessUI, gbc);
        this.add((Component)this.imageAndMapPanel, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        FancyButton prevBtn = new FancyButton("<-");
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)prevBtn, gbc);
        FancyButton nextBtn = new FancyButton("->");
        gbc.gridx = 1;
        this.add((Component)nextBtn, gbc);
        FancyButton guessBtn = new FancyButton("Guess");
        gbc.gridx = 2;
        this.add((Component)guessBtn, gbc);
        this.backBtn = new BackButton(mainWindow, "BACK");
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        this.add((Component)this.backBtn, gbc);
        this.nextGameBtn = new FancyButton("NEXT_GAME");
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        this.add((Component)this.nextGameBtn, gbc);
        prevBtn.addActionListener(e -> this.imageLabel.scrollRight());
        nextBtn.addActionListener(e -> this.imageLabel.scrollLeft());
        guessBtn.addActionListener(e -> {
            try {
                this.guessed(this.map.getDistanceAccuracy());
            }
            catch (InvalidDistanceException ex) {
                System.out.println("Invalid distance computed! This should not have occurred!");
            }
        });
        this.nextGameBtn.addActionListener(e -> {
            try {
                this.nextRound(this.mDist);
            }
            catch (InvalidGoalPositionException ex) {
                System.out.println("Goal position is set to invalid!");
            }
        });
    }

    @Override
    @Deprecated
    public void actionPerformed(ActionEvent e) {
    }
}

