/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.views;

import hu.afghangoat.ConfigParser;
import hu.afghangoat.LangEntry;
import hu.afghangoat.LangParser;
import hu.afghangoat.exceptions.InvalidGoalPositionException;
import hu.afghangoat.helpers.ImageHelper;
import hu.afghangoat.views.MainWindow;
import hu.afghangoat.views.ViewInterface;
import hu.afghangoat.widgets.FancyButton;
import hu.afghangoat.widgets.GradientPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MenuPanel
extends GradientPanel
implements ViewInterface,
ActionListener {
    private JLabel label = new JLabel("TITLE");
    private JButton howToPlayBtn;
    private JButton startBtn;
    private JButton settingsBtn;
    private JButton creditsBtn;
    private JButton topPanelBtn;

    @Override
    public void langChanged() {
        this.label.setText(LangParser.getLang("TITLE"));
        this.howToPlayBtn.setText(LangParser.getLang("HOWTOPLAY"));
        this.settingsBtn.setText(LangParser.getLang("SETTINGS"));
        this.creditsBtn.setText(LangParser.getLang("CREDITS"));
        this.startBtn.setText(LangParser.getLang("START"));
        this.topPanelBtn.setText(LangParser.getLang("TOPBTN"));
    }

    public MenuPanel(MainWindow mainWindow) {
        super(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 10, 10, 10);
        ImageIcon icon = new ImageIcon(ConfigParser.getConfigPath() + "icon.png");
        JLabel label2 = new JLabel(icon);
        GridBagConstraints image_gbc = new GridBagConstraints();
        image_gbc.gridx = 0;
        image_gbc.gridy = -1;
        image_gbc.anchor = 10;
        image_gbc.fill = 0;
        image_gbc.insets = new Insets(40, 10, 25, 10);
        this.add((Component)label2, image_gbc);
        GridBagConstraints label_gbc = new GridBagConstraints();
        label_gbc.gridx = 0;
        label_gbc.gridy = -1;
        label_gbc.anchor = 10;
        label_gbc.fill = 0;
        label_gbc.insets = new Insets(0, 10, 25, 10);
        this.label.setFont(new Font("Segoe UI", 1, 30));
        this.add((Component)this.label, label_gbc);
        this.startBtn = new FancyButton("START");
        this.startBtn.addActionListener(e -> {
            try {
                mainWindow.requestStartRound();
            }
            catch (InvalidGoalPositionException ex) {
                System.out.println("Failed to start the round! Invalid goal position was set!");
            }
            mainWindow.showView("GAME");
        });
        this.add((Component)this.startBtn, gbc);
        this.howToPlayBtn = new FancyButton("HOWTOPLAY");
        this.howToPlayBtn.addActionListener(e -> mainWindow.showView("HOWTO"));
        this.add((Component)this.howToPlayBtn, gbc);
        this.settingsBtn = new FancyButton("SETTINGS");
        this.settingsBtn.addActionListener(e -> mainWindow.showView("SETTINGS"));
        this.add((Component)this.settingsBtn, gbc);
        this.creditsBtn = new FancyButton("CREDITS");
        this.creditsBtn.addActionListener(e -> mainWindow.showView("CREDITS"));
        this.add((Component)this.creditsBtn, gbc);
        this.topPanelBtn = new FancyButton("TOPBTN");
        this.topPanelBtn.addActionListener(e -> {
            mainWindow.showView("TOP_PANEL");
            mainWindow.onTopListMessageReceived();
        });
        this.add((Component)this.topPanelBtn, gbc);
        JPanel rowPanel = new JPanel();
        rowPanel.setOpaque(true);
        rowPanel.setLayout(new FlowLayout(1, 10, 5));
        List<LangEntry> langs = mainWindow.cp.getLanguages();
        if (langs != null) {
            for (int i = 0; i < langs.size(); ++i) {
                System.out.println(langs.get(i).getName());
                ImageIcon tempLangIcon = ImageHelper.resizedImage(ConfigParser.getLangsPath() + langs.get(i).getName() + ".png", (int)(192.0 * mainWindow.cp.getLangIconScale()), (int)(128.0 * mainWindow.cp.getLangIconScale()));
                FancyButton lang_btn = new FancyButton(tempLangIcon);
                lang_btn.setToolTipText(langs.get(i).getTooltip());
                rowPanel.add(lang_btn);
                String langName = langs.get(i).getName();
                lang_btn.addActionListener(e -> {
                    mainWindow.cp.setCurrentLang(langName);
                    mainWindow.setRF(new LangParser(ConfigParser.getLangsPath() + langName + ".lang"));
                    mainWindow.changeLangForAll();
                });
            }
        }
        this.add((Component)rowPanel, gbc);
    }

    @Override
    @Deprecated
    public void actionPerformed(ActionEvent e) {
    }
}

