/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.widgets;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;

public class FancyButton
extends JButton {
    private Color baseColor = new Color(255, 255, 255);
    private Color hoverColor = new Color(204, 0, 0);
    private boolean hover = false;

    public FancyButton(String text) {
        super(text);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setForeground(Color.BLACK);
        this.setFont(new Font("Segoe UI", 1, 16));
        this.setBorder(new EmptyBorder(10, 20, 10, 20));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                FancyButton.this.hover = true;
                FancyButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FancyButton.this.hover = false;
                FancyButton.this.repaint();
            }
        });
    }

    public FancyButton(ImageIcon tempLangIcon) {
        super(tempLangIcon);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setForeground(Color.BLACK);
        this.setFont(new Font("Segoe UI", 1, 16));
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                FancyButton.this.hover = true;
                FancyButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FancyButton.this.hover = false;
                FancyButton.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color fill = this.hover ? this.hoverColor : this.baseColor;
        g2.setColor(fill);
        RoundRectangle2D.Float rectBorder = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 0.0f, 0.0f);
        Color startColor = this.hover ? this.hoverColor.brighter() : this.baseColor.brighter();
        Color endColor = this.hover ? this.hoverColor.darker() : this.baseColor.darker();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, startColor, 0.0f, this.getHeight(), endColor);
        g2.setPaint(gp);
        g2.fill(rectBorder);
        super.paintComponent(g);
        g2.dispose();
    }
}

