/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.widgets;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ScrollableImage
extends ImageIcon {
    private int maxLengthX = 0;
    private int itargetWidth = 0;
    private int itargetHeight = 0;
    private int currentPosX = 0;
    private BufferedImage output;
    private BufferedImage scaledBuffered;
    private BufferedImage original;
    private int newWidth;
    private int newHeight;

    public ScrollableImage() {
    }

    public ScrollableImage(String path, int targetWidth, int targetHeight) {
        double scaleY;
        this.itargetWidth = targetWidth;
        this.itargetHeight = targetHeight;
        this.currentPosX = 0;
        try {
            this.original = ImageIO.read(new File(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int originalWidth = this.original.getWidth();
        int originalHeight = this.original.getHeight();
        double scale = scaleY = (double)targetHeight / (double)originalHeight;
        this.newWidth = (int)((double)originalWidth * scale);
        this.newHeight = (int)((double)originalHeight * scale);
        Image temp = this.original.getScaledInstance(this.newWidth, this.newHeight, 4);
        this.scaledBuffered = new BufferedImage(this.newWidth, this.newHeight, 2);
        Graphics2D g = this.scaledBuffered.createGraphics();
        g.drawImage(temp, 0, 0, null);
        g.dispose();
        this.maxLengthX = Math.max(0, this.newWidth - targetWidth);
        this.moveViewport(this.currentPosX);
    }

    public void moveViewport(int posX) {
        int safePosX;
        this.currentPosX += posX;
        this.currentPosX = safePosX = Math.max(0, Math.min(this.currentPosX, this.maxLengthX));
        this.output = new BufferedImage(this.itargetWidth, this.itargetHeight, 2);
        Graphics2D g2 = this.output.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, this.output.getWidth(), this.output.getHeight());
        g2.setComposite(AlphaComposite.SrcOver);
        int srcX1 = safePosX;
        int srcY1 = 0;
        int srcX2 = Math.min(safePosX + this.output.getWidth(), this.scaledBuffered.getWidth());
        int srcY2 = this.scaledBuffered.getHeight();
        int destWidth = srcX2 - srcX1;
        int destHeight = srcY2 - srcY1;
        int destY = (this.output.getHeight() - destHeight) / 2;
        g2.drawImage(this.scaledBuffered, 0, destY, destWidth, destY + destHeight, srcX1, srcY1, srcX2, srcY2, null);
        g2.dispose();
        this.setImage(this.output);
    }

    private void setImage(BufferedImage img) {
        this.output = img;
        super.setImage(img);
    }
}

