/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.widgets;

import hu.afghangoat.widgets.ScrollableImage;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

public class ScrollableImageFrame
extends JLabel {
    private ScrollableImage icon;
    public static final int SCROLL_AMOUNT_IN_PX = 100;

    public ScrollableImageFrame(ScrollableImage img) {
        super(img);
        this.icon = img;
        this.registerKeyEvents();
    }

    public ScrollableImageFrame() {
        this.registerKeyEvents();
    }

    public void registerKeyEvents() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke("LEFT"), "moveRight");
        this.getActionMap().put("moveRight", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollableImageFrame.this.scrollRight(12);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke("RIGHT"), "moveLeft");
        this.getActionMap().put("moveLeft", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollableImageFrame.this.scrollLeft(12);
            }
        });
    }

    public void scrollLeft() {
        this.icon.moveViewport(100);
        this.repaint();
    }

    public void scrollRight() {
        this.icon.moveViewport(-100);
        this.repaint();
    }

    public void scrollLeft(int px) {
        this.icon.moveViewport(px);
        this.repaint();
    }

    public void scrollRight(int px) {
        this.icon.moveViewport(-px);
        this.repaint();
    }
}

