package hu.afghangoat.blockchain;

import java.util.Objects;

/**
 * @class Transaction
 * @brief A transaction stores a top list entry, which consists from a score and a source name.
 *
 */
public class Transaction {

    /**
     * @brief The source name of the top list entry's participant.
     */
    private String source;

    /**
     * @brief A getter for the score field.
     *
     * @return The score.
     */
    public int getScore() {
        return score;
    }

    /**
     * @brief A setter for the score field.
     *
     * @param score The new score.
     */
    public void setScore(int score) {
        this.score = score;
    }

    /**
     * @brief The score of the entry participant.
     */
    private int score;

    /**
     * @brief A basic constructor for the transaction which takes in a score and a participant name.
     *
     * @param source The participant's name.
     * @param score The participant's score.
     */
    public Transaction(String source, int score) {
        this.source = source;
        this.score = score;
    }

    /**
     * @brief A getter for the participant's name field.
     *
     * @return The participant's name.
     */
    public String getSource() {
        return source;
    }

    /**
     * @brief A setter for the participant's name field.
     *
     * @param source The participant's new name.
     */
    public void setSource(String source) {
        this.source = source;
    }

    /**
     * @brief An empty default constructor.
     */
    Transaction(){

    }

    /**
     * @brief Checks whether 2 instances of transactions are equal by stored value.
     *
     * @param o the RHS object.
     *
     * @return Whether they are equal.
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Transaction)) return false;
        Transaction that = (Transaction) o;
        return score == that.score && Objects.equals(source, that.source);
    }

    /**
     * @brief Generates a hash code based on the inner values of the transactions.
     *
     * @return The generated hash code.
     */
    @Override
    public int hashCode() {
        return Objects.hash(source, score);
        /*
        * final int prime = 31;
    int result = 1;
    result = prime * result + (int) (a ^ (a >>> 32));
    result = prime * result + (int) (b ^ (b >>> 32));
    result = prime * result + (int) (c ^ (c >>> 32));
    return result;
        * */
    }

    /**
     * @brief A method which converts a transaction instance to a serializable text format.
     *
     * @return The text format of the transaction.
     */
    @Override
    public String toString() {
        return "Transaction{" +
                "source=':" + source + ":'" +
                ", score=:" + score +
                ":}";
    }
}
