package hu.afghangoat.helpers;

/**
 * @class MathHelpers
 * @brief Utility class providing mathematical helper functions.
 *
 * The MathHelpers class includes a set of static methods that help
 * perform common mathematical operations such as clamping a value
 * within a given range.
 */
public class MathHelpers {

    /**
     * @brief Clamps a float value between a minimum and maximum range.
     *
     * If @p val is less than @p min, @p min is returned.
     * If @p val is greater than @p max, @p max is returned.
     * Otherwise, @p val is returned unchanged.
     *
     * @param val The value to clamp.
     * @param min The minimum allowed value.
     * @param max The maximum allowed value.
     * @return The clamped float value.
     */
    public static float clampf(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    /**
     * @brief Clamps a double value between a minimum and maximum range.
     *
     * If @p val is less than @p min, @p min is returned.
     * If @p val is greater than @p max, @p max is returned.
     * Otherwise, @p val is returned unchanged.
     *
     * @param val The value to clamp.
     * @param min The minimum allowed value.
     * @param max The maximum allowed value.
     * @return The clamped double value.
     */
    public static double clampd(double val, double min, double max) {
        return Math.max(min, Math.min(max, val));
    }

    /**
     * @brief Clamps an integer value between a minimum and maximum range.
     *
     * If @p val is less than @p min, @p min is returned.
     * If @p val is greater than @p max, @p max is returned.
     * Otherwise, @p val is returned unchanged.
     *
     * @param val The value to clamp.
     * @param min The minimum allowed value.
     * @param max The maximum allowed value.
     * @return The clamped integer value.
     */
    public static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }
}
