package hu.afghangoat.views;

import hu.afghangoat.LangParser;
import hu.afghangoat.widgets.BackButton;
import hu.afghangoat.widgets.GradientPanel;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * @class CreditsPanel
 * @brief The panel class which is supposed to show the users who worked on the project.
 *
 */
public class CreditsPanel extends GradientPanel implements ViewInterface, ActionListener {

    /**
     * @brief This label will display the credits of the game language-wise.
     */
    private JLabel label = new JLabel("CREDITS_DESCRIPTION");

    /**
     * @brief Clicking the "back" button will take the user back to the main menu.
     */
    private BackButton backBtn;

    /**
     * @brief This method handles what should happen when the language is changed.
     */
    @Override
    public void langChanged(){
        label.setText(LangParser.getLang("CREDITS_DESCRIPTION"));
        backBtn.setText(LangParser.getLang("BACK"));
    }

    /**
     * @brief This constructor sets up the layout of the panel and sets the event listeners. Also takes the parent window account.
     *
     * @param mainWindow The parent window of the panel.
     */
    public CreditsPanel(MainWindow mainWindow) {
        super(new GridBagLayout());

        //setLayout();

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = GridBagConstraints.RELATIVE;
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.fill = GridBagConstraints.NONE;
        //label_gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 10, 25, 10); // spacing

        backBtn = new BackButton(mainWindow,"BACK");

        label.setFont(new Font("Segoe UI", Font.BOLD, 30));
        add(label,gbc);

        add(backBtn,gbc);
    }

    /**
     * @brief Empty action listener, needs to be implemented.
     *
     * @param e The event of the action.
     * @deprecated Moved logic to the constructor.
     */
    @Override
    @Deprecated
    public void actionPerformed(ActionEvent e) {

    }
}