package hu.afghangoat.views;

import hu.afghangoat.LangParser;
import hu.afghangoat.widgets.BackButton;
import hu.afghangoat.widgets.GradientPanel;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * @class TopListPanel
 * @brief Displays those who earned the most score in the game.
 *
 * Also displays if the top list save is deemed "cheated".
 *
 */
public class TopListPanel extends GradientPanel implements ViewInterface, ActionListener {

    /**
     * @brief The top N entries will be visible in this page.
     */
    public static final int VISIBLE_TOP_ENTRIES=10;

    /**
     * @brief Holds a general description of the panel's content.
     */
    private JLabel label = new JLabel("TOP_LIST_DESCRIPTION");

    /**
     * @brief Holds the top list in a HTML format.
     */
    private JLabel topListEntriesLabel = new JLabel();

    /**
     * @brief Clicking the "back" button will take the user back to the main menu.
     */
    private BackButton backBtn;

    /**
     * @brief This method handles what should happen when the language is changed.
     */
    @Override
    public void langChanged(){
        label.setText(LangParser.getLang("TOP_LIST_DESCRIPTION").replace("$",Integer.toString(VISIBLE_TOP_ENTRIES)));
        backBtn.setText(LangParser.getLang("BACK"));
        repaint();
    }

    /**
     * @brief Sets the top list label to a new HTML list element.
     *
     * @param data The entries in an unordered list HTML element.
     */
    public void setTopListEntriesLabel(String data){
        topListEntriesLabel.setText(data);
    }

    /**
     * @brief This constructor sets up the layout of the panel and sets the event listeners. Also takes the parent window account.
     *
     * @param mainWindow The parent window of the panel.
     */
    public TopListPanel(MainWindow mainWindow) {
        super(new GridBagLayout());

        //setLayout();

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = GridBagConstraints.RELATIVE;
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.fill = GridBagConstraints.NONE;
        //label_gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 10, 25, 10); // spacing

        backBtn = new BackButton(mainWindow,"BACK");

        label.setFont(new Font("Segoe UI", Font.BOLD, 30));
        add(label,gbc);

        topListEntriesLabel.setFont(new Font("Segoe UI", Font.PLAIN, 26));
        add(topListEntriesLabel,gbc);

        add(backBtn,gbc);
    }

    /**
     * @brief Empty action listener, needs to be implemented.
     *
     * @param e The event of the action.
     * @deprecated Moved logic to the constructor.
     */
    @Override
    @Deprecated
    public void actionPerformed(ActionEvent e) {

    }
}