package hu.afghangoat.widgets;

import hu.afghangoat.views.MainWindow;

/**
 * @class BackButton
 * @brief A button which's sole goal is to take the user back to the main menu.
 *
 */
public class BackButton extends FancyButton {

    /**
     * @brief Sets the main menu destination on click using the constructor.
     *
     * @param mainWindow The root window of the panel the button is located.
     * @param text The text display of the button.
     */
    public BackButton(MainWindow mainWindow, String text) {
        super(text);

        addActionListener(e -> mainWindow.showView("MENU"));
    }
}
