package hu.afghangoat.widgets;

import javax.swing.*;
import java.awt.*;

/**
 * @class GradientPanel
 * @brief A Swing panel class which can have a theme-wise gradient background.
 */
public class GradientPanel extends JPanel {

    /**
     * @brief A default constructor which sets a grid bag layout.
     *
     * @param gridBagLayout The grid bag layout element.
     */
    public GradientPanel(GridBagLayout gridBagLayout) {
        super(gridBagLayout);
    }

    /**
     * @brief The first component of the gradient background.
     */
    private static Color gradientColor1 = new Color(204, 0, 0);

    /**
     * @brief The second component of the gradient background.
     */
    private static Color gradientColor2 =  new Color(255, 180, 180);

    /**
     * @brief The text color of the panel.
     */
    private static Color fontColor = Color.BLACK;

    /**
     * @brief A setter for both gradient colors.
     *
     * @param c1 The first color.
     * @param c2 The second color.
     */
    public static void setGradientColors(Color c1, Color c2){
        gradientColor1 = c1;
        gradientColor2 = c2;
    }

    /**
     * @brief A setter for the text color.
     *
     * @param tc The new text color.
     */
    public void setTextColor(Color tc){
        fontColor = tc;

        for (Component comp : getComponents()) {
            comp.setForeground(fontColor);
        }
    }

    /**
     * @brief Overrides the default rendering to render the custom gradient background.
     *
     * @param g The graphics renderer element.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g.create();
        GradientPaint paint = new GradientPaint(
                0, 0, gradientColor1,
                getWidth(), getHeight(), gradientColor2
        );
        g2.setPaint(paint);
        g2.fillRect(0, 0, getWidth(), getHeight());
        g2.dispose();
    }

    /**
     * @brief An overridden add method which overrides the font color of the new element added to the panel.
     *
     * @param comp The new component which needs to be added.
     */
    @Override
    public Component add(Component comp) {
        comp.setForeground(fontColor);
        return super.add(comp);
    }
}
