package hu.afghangoat.widgets;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * @class ScrollableImageFrame
 * @brief A scrollable image holder which command the scrolling and the offsetting of the held image.
 */
public class ScrollableImageFrame extends JLabel{

    /**
     * @brief The reference to the scrollable image.
     */
    private ScrollableImage icon;

    /**
     * @brief The amount that a single scroll event will offset the X axis.
     */
    public static final int SCROLL_AMOUNT_IN_PX=100;

    /**
     * @brief A constructor which sets a scrollable image as a self-image.
     *
     * @param img The reference to the scrollable image.
     */
    public ScrollableImageFrame(ScrollableImage img){
        super(img);
        icon = img;

        registerKeyEvents();
    }

    /**
     * @brief A default constructor which calls the parent's constructor.
     */
    public ScrollableImageFrame(){
        super();

        registerKeyEvents();
    }

    /**
     * @brief Registers the events which will help in the moving of the inner image with key presses.
     *
     * Gets called in the constructors.
     */
    public void registerKeyEvents(){

        //Right-Left switched due to inverse scrolling.
        getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("LEFT"), "moveRight");
        getActionMap().put("moveRight", new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                scrollRight(12);
            }
        });

        getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("RIGHT"), "moveLeft");
        getActionMap().put("moveLeft", new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                scrollLeft(12);
            }
        });
    }

    /**
     * @brief Delegates a left scroll to the image.
     */
    public void scrollLeft(){
        icon.moveViewport(SCROLL_AMOUNT_IN_PX);
        repaint();
    }

    /**
     * @brief Delegates a right scroll to the image.
     */
    public void scrollRight(){
        icon.moveViewport(-SCROLL_AMOUNT_IN_PX);
        repaint();
    }

    /**
     * @brief Delegates a left scroll to the image by some amount.
     *
     * @param px The scroll amount.
     */
    public void scrollLeft(int px){
        icon.moveViewport(px);
        repaint();
    }

    /**
     * @brief Delegates a right scroll to the image by some amount.
     *
     * @param px The scroll amount.
     */
    public void scrollRight(int px){
        icon.moveViewport(-px);
        repaint();
    }
}
