package hu.afghangoat.widgets;

import java.awt.*;

/**
 * @class StyleWidget
 * @brief Holds information about a single theme.
 */
public class StyleWidget {

    /**
     * @brief The first background gradient color component.
     */
    private Color bgGradientColor1 = new Color(66, 66, 66);

    /**
     * @brief Getter for the first background gradient color component.
     */
    public Color getBgGradientColor1() {
        return bgGradientColor1;
    }

    /**
     * @brief Getter for the font text color.
     */
    public Color getFontColor() {
        return fontColor;
    }

    /**
     * @brief Getter for the theme name.
     */
    public String getName() {
        return name;
    }

    /**
     * @brief Getter for the second background gradient color component.
     */
    public Color getBgGradientColor2() {
        return bgGradientColor2;
    }

    /**
     * @brief The second background gradient color component.
     */
    private Color bgGradientColor2 = new Color(0, 0, 0);

    /**
     * @brief The theme's font text color.
     */
    private Color fontColor = Color.WHITE;

    /**
     * @brief The theme's name. "UNSET" by default.
     */
    private String name = "UNSET";

    /**
     * @brief A constructor which sets all the colors and the name for the theme.
     *
     * @param gc1 The first background gradient color component.
     * @param gc2 The second background gradient color component.
     * @param fC The theme's font color.
     * @param style_name The theme's name.
     */
    public StyleWidget(Color gc1, Color gc2, Color fC, String style_name){
        bgGradientColor1=gc1;
        bgGradientColor2=gc2;
        fontColor=fC;
        name=style_name;
    }
}
